﻿using System;

using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Runtime.InteropServices;		// needed for langtran.dll DllImport
using System.Diagnostics;					// needed for Process.Start, to start setup.exe
using MettlerToledo.IND780.SharedDataClient;
using System.IO.Ports;
using MettlerToledo.IND780.Information;
using MettlerToledo.IND780.Softkeys;

namespace Classify_Application
{
	public partial class ClassifyMain : Form
	{
		public static SDclient SD_client;

		private Softkeys mySoftkeys;

		public static int language = 0;

		[DllImport("langtran.dll")]
		public static extern IntPtr GetTextString(int index, int language);

		//private enum FormToOpen
		//{
		//    CLASS_MAIN = 0,
		//    CLASS_COLORS = 1,
		//    CLASS_RANGES = 2,
		//    CLASS_START = 3,
		//    CLASS_STOP = 4
		//}

		//private FormToOpen formToOpen = FormToOpen.CLASS_MAIN;

		public static SerialPort serialPort_1 = new SerialPort();
		public static SerialPort serialPort_2 = new SerialPort();

		/*---------------------------------------------------------------------------------------------------------*
		* Name          :ClassifyMain::ClassifyMain
		* Description   :Constructor
		* Return Value  :None
		* --------------------------------------------------------------------------------------------------------*/
		public ClassifyMain()
		{
			SD_client = new SDclient();

			InitializeComponent();

			this.SharedDataServerConnect();
			this.SoftkeysInitialization();
			this.RegisterSoftkeys();
			ClassifyMain.GetLanguage();
		}

		/*---------------------------------------------------------------------------------------------------------*
		* Name          :ClassifyMain::SharedDataServerConnect
		* Description   :Connects to the IND780 Shared Data Server.  Displays a green square in the upper left
		*				:corner if successful or a red square if not successful.
		* Return Value  :True - Connected successfully
		*				:False - Failed to connect.  Check IND780 power and cables.
		* --------------------------------------------------------------------------------------------------------*/
		private bool SharedDataServerConnect()
		{
			int connectionStatus = SD_client.ConnectToSharedDataServer("admin", "");

			if (connectionStatus == 0)
			{
				this.label_connected.BackColor = Color.Lime;
				this.label_connected.Refresh();
				return true;
			}
			this.label_connected.BackColor = Color.Red;
			this.label_connected.Refresh();
			return false;
		}

		/*---------------------------------------------------------------------------------------------------------*
		* Name          :Form1::SoftkeysInitialization
		* Description   :Creates the five picture boxes and draws the softkey borders used by the softkeys
		* Return Value  :None
		* --------------------------------------------------------------------------------------------------------*/
		private void SoftkeysInitialization()
		{
			mySoftkeys = new Softkeys();
			mySoftkeys.AllocateSoftkeys(this, 175, @"Storage Card\Terminal\SKBMP\COLOR\");
		}

		/*---------------------------------------------------------------------------------------------------------*
		* Name          :Form1::RegisterSoftkeys
		* Description   :Registers the softkey graphic and method used by each softkey.
		* Return Value  :None
		* --------------------------------------------------------------------------------------------------------*/
		private void RegisterSoftkeys()
		{
			// level 0 softkeys
			mySoftkeys.LoadSoftkeys(0, 0, true, @"Storage Card\Terminal\SKBMP\COLOR\exit.bmp", (Softkeys.mySKMethodDelegate)ClassifyExit);
			mySoftkeys.LoadSoftkeys(0, 1, true, @"Storage Card\Terminal\SKBMP\COLOR\classifyColors.bmp", (Softkeys.mySKMethodDelegate)ClassifyColors);
			mySoftkeys.LoadSoftkeys(0, 2, true, @"Storage Card\Terminal\SKBMP\COLOR\classifyThresholds.bmp", (Softkeys.mySKMethodDelegate)ClassifyThresholds);
			mySoftkeys.LoadSoftkeys(0, 3, true, @"Storage Card\Terminal\SKBMP\COLOR\info.bmp", (Softkeys.mySKMethodDelegate)ClassifyInfo);
			mySoftkeys.LoadSoftkeys(0, 4, true, @"Storage Card\Terminal\SKBMP\COLOR\advance.bmp", (Softkeys.mySKMethodDelegate)ClassifyNextSoftkeyLevel);

			mySoftkeys.LoadSoftkeys(1, 0, true, @"Storage Card\Terminal\SKBMP\COLOR\com.bmp", (Softkeys.mySKMethodDelegate)ClassifyComConfigure);
			mySoftkeys.LoadSoftkeys(1, 1, false, @"", null);
			mySoftkeys.LoadSoftkeys(1, 2, true, @"Storage Card\Terminal\SKBMP\COLOR\start.bmp", (Softkeys.mySKMethodDelegate)ClassifyStart);
			mySoftkeys.LoadSoftkeys(1, 3, true, @"Storage Card\Terminal\SKBMP\COLOR\stop.bmp", (Softkeys.mySKMethodDelegate)ClassifyKillSetup);
			mySoftkeys.LoadSoftkeys(1, 4, true, @"Storage Card\Terminal\SKBMP\COLOR\advance.bmp", (Softkeys.mySKMethodDelegate)ClassifyNextSoftkeyLevel);

			mySoftkeys.NumberOfLevels = 2;

			mySoftkeys.DisplaySoftKeys(0);
		}

		private void ClassifyExit()
		{
			this.Close();
		}

		private void ClassifyColors()
		{
			this.label_ClassifyApplication.Text = "Loading...";
			this.Refresh();
			Application.Run(new Form1());
		}

		/*---------------------------------------------------------------------------------------------------------*
		* Name          :Form1::ClassifyInfo
		* Description   :Opens the Information class form
		* Return Value  :None
		* --------------------------------------------------------------------------------------------------------*/
		private void ClassifyInfo()
		{
			this.label_ClassifyApplication.Text = "Loading...";
			this.Refresh();
			InfoClass info = new InfoClass();
		}

		private void ClassifyThresholds()
		{
			this.label_ClassifyApplication.Text = "Loading...";
			this.Refresh();
			Application.Run(new Form2());
		}

		private void ClassifyStart()
		{
			this.label_ClassifyApplication.Text = "Loading...";
			this.Refresh();
			Application.Run(new Form3());
		}

		/*---------------------------------------------------------------------------------------------------------*
		* Name          :Form1::ClassifyNextSoftkeyLevel
		* Description   :Displays the next level of softkeys
		* Return Value  :None
		* --------------------------------------------------------------------------------------------------------*/
		private void ClassifyNextSoftkeyLevel()
		{
			mySoftkeys.DisplayNextSoftkeyLevel();
		}

		private void ClassifyComConfigure()
		{
			this.label_ClassifyApplication.Text = "Loading...";
			this.Refresh();
			Application.Run(new Form4());
		}

		private void ClassifyKillSetup()
		{
			SD_client.KillSetup();
		}

		/*---------------------------------------------------------------------------------------------------------*
		* Name          :ClassifyMain::Common_KeyUp
		* Description   :Common key-up event handler for all keys.  Calls the softkeys dispatcher
		* Return Value  :None
		* --------------------------------------------------------------------------------------------------------*/
		void Common_KeyUp(object sender, System.Windows.Forms.KeyEventArgs e)
		{
			mySoftkeys.SoftkeyDispatcher((int)e.KeyCode);
		}

		/*---------------------------------------------------------------------------------------------------------*
		* Name          :ClassifyMain::Common_KeyPress
		* Description   :Common key-down event handler for all keys.  Forces a key click noise.
		* Return Value  :None
		* --------------------------------------------------------------------------------------------------------*/
		void Common_KeyDown(object sender, System.Windows.Forms.KeyEventArgs e)
		{
			ClassifyMain.SD_client.SetSharedData("xc0134", "1");	// key click
		}

		/*---------------------------------------------------------------------------------------------------------*
		* Name          :ClassifyMain::Form1_Paint
		* Description   :The ClassifyMain Paint event handler.
		* Return Value  :None
		* --------------------------------------------------------------------------------------------------------*/
		void ClassifyMain_Paint(object sender, System.Windows.Forms.PaintEventArgs e)
		{
			mySoftkeys.DrawSoftkeyBorders(this);
		}

		/*---------------------------------------------------------------------------------------------------------*
		* Name          :ClassifyMain::ClassifyMain_GotFocus
		* Description   :The ClassifyMain Got Focus event handler.  This event handler is needed to replace the
		*				:"Loading..." text when opening another form.
		* Return Value  :None
		* --------------------------------------------------------------------------------------------------------*/
		void ClassifyMain_GotFocus(object sender, System.EventArgs e)
		{
			this.label_ClassifyApplication.Text = "Classify Application";
		}

		/*---------------------------------------------------------------------------------------------------------*
		* Name          :ClassifyMain::GetLanguage
		* Description   :Gets the currently selected language
		* Return Value  :None
		* --------------------------------------------------------------------------------------------------------*/
		private static void GetLanguage()
		{
			language = int.Parse(SD_client.ReadSharedData("xs0115"));
		}

		/*---------------------------------------------------------------------------------------------------------*
		* Name          :ClassifyMain::GetString
		* Description   :Get the requested string using langtran.dll.
		* Return Value  :string
		* --------------------------------------------------------------------------------------------------------*/
		public static string GetString(int Number)
		{
			IntPtr pString = GetTextString(Number, language);
			string strString = Marshal.PtrToStringUni(pString);
			return strString;
		}

		/*---------------------------------------------------------------------------------------------------------*
		* Name          :ClassifyMain::ClassifyMain_Closing
		* Description   :Event handler called when form is closing to start setup.exe (IND780 Control Panel)
		* Return Value  :none
		* --------------------------------------------------------------------------------------------------------*/
		void ClassifyMain_Closing(object sender, System.ComponentModel.CancelEventArgs e)
		{
			//Process.Start(@"Storage Card\Terminal\CP\setup.exe", "");
			Process p = Process.GetCurrentProcess();
			p.Kill();
		}

	}
}